function eigenfaces_scatter(images, indices);

[w, h, nExpressions, nIndividuals]=size(images);
X=reshape(images,[w*h,nIndividuals*nExpressions]);
avg=mean(X,2);
Xd=bsxfun(@minus,X,avg);
[U,S,V]=svd(Xd,0);
scores=U(:,indices)'*Xd;
%normalize scores and samples
%scores=bsxfun(@rdivide,scores,sqrt(sum(abs(scores).^2)));

if length(indices) == 3
    scatter3(scores(1,:),scores(2,:),scores(3,:),50*ones(size(scores(1,:))),kron(1:nIndividuals,ones(1,nExpressions)));
elseif length(indices) == 2
    scatter(scores(1,:),scores(2,:),50*ones(size(scores(1,:))),kron(1:nIndividuals,ones(1,nExpressions)));
else
    error('wrong indices size');
end
