function interactiverec(F)
% given a 243x320 image F, displays it as sum of components
stdsize=[243,320];

F = F(:);

if not(numel(F) == prod(stdsize))
    error('The first argument must be the picture to reconstruct');
end

X=readyalefaces_to_tensor;
X=reshape(X,[prod(stdsize),numel(X)/prod(stdsize)]);
avg=mean(X,2);
Xs=bsxfun(@minus,X,avg);
[U,S,V]=svd(X,0);
colormap(gray);
ncolors=size(gray,1);
h = image(reshape(avg,stdsize)*ncolors);

% Add a slider
uicontrol('Style', 'slider', 'Min', 0, 'Max',  size(U,2), ...
    'Callback', @callback,'Position',[10 0 300 20]);

function callback(src,evt)
d=round(get(src, 'Value'))
set(h, 'CData', reshape(ncolors*(avg+U(:,1:d)*(U(:,1:d)'*F)),stdsize));
end

end
