function [F,descr] = readyalefaces_to_tensor(str)

if not(exist('str','var'))
    str='all';
end
switch str
    case 'easy'
        extensions = {'happy', 'normal', 'sad', 'sleepy', 'surprised', 'wink' };
    case 'easy-nowink'
        extensions = {'happy', 'normal', 'sad', 'sleepy', 'surprised' };
    case 'nowink'
        extensions = {'centerlight', 'glasses', 'happy', 'leftlight', 'noglasses', 'normal', 'rightlight', 'sad', 'sleepy', 'surprised' };
    case {'hard','all'}
        extensions = {'centerlight', 'glasses', 'happy', 'leftlight', 'noglasses', 'normal', 'rightlight', 'sad', 'sleepy', 'surprised', 'wink' };
    otherwise
        error 'unknown selector';
end

for i = 1 : 15,
    basename = 'yalefaces/subject';
    if( i < 10 )
        basename = [basename, '0', num2str(i)];
    else
        basename = [basename, num2str(i)];
    end;

    for j = 1:length(extensions),
        fullname = [basename, '.', extensions{j}, '.gif'];
        X = imread(fullname);
        F(:,:,j,i) = double(X)/255;
    end;

end;
descr=extensions;