/*
 * Decompiled with CFR 0.152.
 */
package Assignment2;

import Assignment2.DuplicateException;
import Assignment2.IncosistencyException;
import Assignment2.Tuple;
import java.util.LinkedList;
import java.util.Queue;
import java.util.TreeMap;

public class ComputingCenter {
    private final TreeMap<Tuple<Integer>, Queue<String>> tasksMap = new TreeMap();

    public void addNewUnit(Tuple<Integer> unit) throws DuplicateException {
        if (this.tasksMap.containsKey(unit)) {
            throw new DuplicateException("Attempting to add an already present unit.");
        }
        this.tasksMap.put(unit, new LinkedList());
    }

    public void addNewTask(String task, Tuple<Integer> unit) throws IncosistencyException {
        if (!this.tasksMap.containsKey(unit)) {
            try {
                this.addNewUnit(unit);
            }
            catch (DuplicateException ex) {
                throw new IncosistencyException("IMPOSSIBLE INCONSISTENCY: same unit both present and not present as key!");
            }
        }
        this.tasksMap.get(unit).add(task);
    }

    public String getFirstTask(Tuple<Integer> unit) throws IncosistencyException {
        if (!this.tasksMap.containsKey(unit)) {
            throw new IncosistencyException("Attempting to remove a task from a non existing unit.");
        }
        return this.tasksMap.get(unit).peek();
    }

    public String removeCompletedTask(Tuple<Integer> unit) throws IncosistencyException {
        if (!this.tasksMap.containsKey(unit)) {
            throw new IncosistencyException("Attempting to remove a task from a non existing unit.");
        }
        return this.tasksMap.get(unit).poll();
    }
}

