import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.ServerSocket;
import java.io.BufferedWriter;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;

public class ChatRoomServer {

	public void go() {
		Vector<BufferedWriter> clients= new Vector<>();
		BlockingQueue<String> messages = new LinkedBlockingQueue<>();
		ExecutorService es= Executors.newCachedThreadPool();
		SenderTask sendTask= new SenderTask(clients,messages);
		es.submit(sendTask);
		
		try(ServerSocket server = new ServerSocket(2000);){
			while(true){
				Socket client = server.accept();
				ClientHandler task = new ClientHandler(client, messages);
				es.submit(task);
				clients.add(new BufferedWriter(
						new OutputStreamWriter(client.getOutputStream())));
			}
		} catch (IOException	 e){}
		finally{
			es.shutdown();
		}
		
	}

}
