import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.concurrent.BlockingQueue;

public class ClientHandler implements Runnable {

	Socket client;
	BlockingQueue<String> messages;
	
	public ClientHandler(Socket client,
			BlockingQueue<String> messages) {
		this.client=client;
		this.messages=messages;
	}

	@Override
	public void run() {
		
		System.out.println("Handling new client "
		+this.client.getInetAddress());
		
		try(BufferedReader in= new BufferedReader(
				new InputStreamReader(this.client.getInputStream()));){
			String message;
			while((message= in.readLine())!=null){
				System.out.println("Ricevuto "
						+message);
				messages.put(message);
				
			}
		} catch(IOException e){} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}

}
