import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SocketChannel;

public class EchoClient {

	public static void main(String[] args) {
		SocketAddress server = 
				new InetSocketAddress("localhost",2000);
		try(ReadableByteChannel local = 
				Channels.newChannel(System.in);
				SocketChannel remote= SocketChannel.open(server)){
			ByteBuffer message= ByteBuffer.allocate(1024);
			local.read(message);
			message.flip();
			ByteBuffer length = ByteBuffer.allocate(Integer.BYTES);
			length.putInt(message.limit());
			length.flip();
			remote.write(length);
			remote.write(message);
			message.clear();
			remote.read(message);
			System.out.println("Received: "+ 
			new String(message.array(),0,message.position()));
		} catch (IOException e){
			e.printStackTrace();
		}
	}

}
