import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public class EchoServer {

	public static void main(String[] args) {

		try(ServerSocketChannel server = ServerSocketChannel.open();
				Selector selector = Selector.open()){
			
			server.bind(new InetSocketAddress("localhost",2000));
			server.configureBlocking(false);
			
			server.register(selector, SelectionKey.OP_ACCEPT);
			
			while(true){
				selector.selectedKeys().clear();
				System.out.println("selecting...");
				selector.select();
				
				for (SelectionKey key : selector.selectedKeys())
				{
					if (key.isAcceptable()){
						try{
							ServerSocketChannel channel= (ServerSocketChannel) key.channel();
							SocketChannel client=channel.accept();
							System.out.println("New client "+ client.getRemoteAddress());
							client.configureBlocking(false);
							ByteBuffer length= ByteBuffer.allocate(Integer.BYTES);
							ByteBuffer message= ByteBuffer.allocate(1024);
							ByteBuffer[] bfs = {length, message};
							client.register(selector, SelectionKey.OP_READ,bfs);
						} catch(IOException e){
							e.printStackTrace();
						}
					}
					if (key.isReadable()){
						try{
							SocketChannel channel= (SocketChannel) key.channel();
							ByteBuffer[] bfs = (ByteBuffer[]) key.attachment();
							long response=channel.read(bfs);
							if (response==-1){
								channel.close();
								key.cancel();
								continue;
							}
							if (!bfs[0].hasRemaining()){
								bfs[0].flip();
								int l=bfs[0].getInt();
								if(bfs[1].position()==l){
									bfs[1].flip();
									channel.register(selector, SelectionKey.OP_WRITE,bfs[1]);
								}
							}
						} catch(IOException e){
							e.printStackTrace();
						}
						
					}
					if (key.isWritable()){
						try{
							SocketChannel channel= (SocketChannel) key.channel();
							ByteBuffer message= (ByteBuffer)key.attachment();
							channel.write(message);
							if (!message.hasRemaining()){
								channel.close();
								key.cancel();	
							}
						} catch(IOException e){
							e.printStackTrace();
						}
					}
				}
			}
			
		} catch( IOException e){
			e.printStackTrace();
		}
	}

}
