package peersim;

import peersim.config.Configuration;
import peersim.core.CommonState;
import peersim.core.Control;
import peersim.core.Network;
import peersim.core.Node;
import peersim.util.IncrementalStats;

/**
 * This class implements the observer, that prints
 * a summary of the state of the network at every iteration.
 * @author carlini
 *
 */
public class AverageObserver implements Control
{
	/*
	 * Only one parameter: the protocol to reference.
	 * "PAR_PROTID" contains the parameter name to be used in the config file.
	 * "pid" will contains the value of the protocol referenced.
	 */
	private final String PAR_PROTID = "protocol";
	private final int pid;
	
	public AverageObserver(String name)
	{
		pid = Configuration.getPid(name+"."+PAR_PROTID);
	}
	
	
	/**
	 * Computes the network average, and the standard deviation.
	 * Terminates when the standard deviation goes below a threshold.
	 */
	@Override
	public boolean execute() 
	{
		final int len = Network.size();
		IncrementalStats stats = new IncrementalStats();
		
		int time = CommonState.getIntTime();
				
		for (int i=0; i < len; i++) {
			Node node = Network.get(i);
			AverageED protocol = (AverageED) node.getProtocol(pid);
			stats.add(protocol.getValue());
		}
		
		System.out.println("TIME: "+time+" AVG: "+stats.getAverage()+" STD: "+stats.getStD());
		
		if (stats.getStD() < 0.1)
			return true;
		
		return false;
	}

}
