package peersim;

import peersim.config.Configuration;
import peersim.core.CommonState;
import peersim.core.Control;
import peersim.core.Network;
import peersim.core.Node;

/**
 * This class initializes the values of the node in the network. 
 * @author carlini
 *
 */
public class AverageInitializer implements Control
{
	/*
	 * Only one parameter: the protocol to reference.
	 * "PAR_PROTID" contains the parameter name to be used in the config file.
	 * "pid" will contains the value of the protocol referenced.
	 */
	private final String PAR_PROTID = "protocol";
	private final int pid;
	
	public AverageInitializer(String name)
	{
		pid = Configuration.getPid(name+"."+PAR_PROTID);
	}
	
	/**
	 * This control works only at the first iteration.
	 * It assigns a random 0-99 integer to each node.
	 */
	@Override
	public boolean execute() 
	{
		int size = Network.size();
		for (int i = 0; i < size; i++)
		{
			Node node = Network.get(i);
			Average protocol = (Average) node.getProtocol(pid);
			
			double value = CommonState.r.nextInt(100);
			protocol.setValue(value);
		}
		
		return false;
	}
	
}
