package peersim;

import peersim.config.Configuration;
import peersim.core.CommonState;
import peersim.core.Control;
import peersim.core.Network;
import peersim.core.Node;
import peersim.util.IncrementalStats;

/**
 * This class implements the observer, that prints
 * a summary of the state of the network at every iteration.
 * @author carlini
 */

public class CyclonObserver implements Control
{
	/*
	 * Only one parameter: the protocol to reference.
	 * "PAR_PROTID" contains the parameter name to be used in the config file.
	 * "pid" will contains the value of the protocol referenced.
	 */
	private final String PAR_PROTID = "protocol";
	private final int pid;
	
	public CyclonObserver(String name)
	{
		pid = Configuration.getPid(name+"."+PAR_PROTID);
	}
	
	
	/**
	 * Computes the network average, and the standard deviation.
	 * Terminates when the standard deviation goes below a threshold.
	 */
	@Override
	public boolean execute() 
	{
		int time = CommonState.getIntTime();
		int[] indegree = new int[Network.size()];
		IncrementalStats stats = new IncrementalStats();
		
		for (int i=0; i < Network.size(); i++) 
		{
			Node node = Network.get(i);
			Cyclon prot = (Cyclon) node.getProtocol(pid);
			
			for (Long id: prot.getView().keySet())
				indegree[id.intValue()]++;
		}
		
		for (int i=0; i<indegree.length; i++)
			stats.add(indegree[i]);
			
		System.out.println("TIME: "+time+" AVG: "+stats.getAverage()+" STD: "+stats.getStD());
		
		return false;
	}

}
