package peersim;

import peersim.core.Node;

public class PeerDescriptor implements Comparable<PeerDescriptor>
{
	private Node node;
	private long age = 0;
	
	
	public Node getNode() 
	{
		return node;
	}
	
	public void setNode(Node node)
	{
		this.node = node;
	}
	
	public long getAge()
	{
		return age;
	}
	
	public void increaseAge()
	{
		this.age ++;
	}


	@Override
	public int compareTo(PeerDescriptor pd) 
	{
		if (pd.age < this.age)
			return -1;
		else if (pd.age > this.age)
			return 1;
		else return 0;
	}
	
	@Override
	public PeerDescriptor clone()
	{
		PeerDescriptor pd = new PeerDescriptor();
		pd.node = this.node;
		pd.age = this.age;
		return pd;
	}
	
	@Override
	public String toString()
	{
		return node.getID() + "("+age+")";
	}
}
