package peersim;

import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Set;

import peersim.config.Configuration;
import peersim.core.CommonState;
import peersim.core.Control;
import peersim.core.Network;
import peersim.core.Node;

public class SystemInitializer implements Control
{
	/*
	 * Only one parameter: the protocol to reference.
	 * "PAR_PROTID" contains the parameter name to be used in the config file.
	 * "pid" will contains the value of the protocol referenced.
	 */
	private final String PAR_PROTCY = "cyclon";
	private final int pid_cyclon;
	
	private final String PAR_PROTVIC = "vicinity";
	private final int pid_vicinity;
		
	private final String PAR_LENGTH = "length";
	private int length;
	
	private final String PAR_WIDTH = "width";
	private int width;
	
	
	public SystemInitializer(String name)
	{
		pid_cyclon = Configuration.getPid(name+"."+PAR_PROTCY);
		pid_vicinity = Configuration.getPid(name+"."+PAR_PROTVIC);
		length = Configuration.getInt(name+"."+PAR_LENGTH);
		width = Configuration.getInt(name+"."+PAR_WIDTH);
	}
	
	/**
	 * This control initializes just the cyclon view
	 */
	@Override
	public boolean execute() 
	{
		int size = Network.size();
		
		// set up vicinity positions
		for (int i=0; i< size; i++)
		{
			Point2D.Double position = new Point2D.Double(CommonState.r.nextInt(length), CommonState.r.nextInt(width));
			
			// add the position to vicinity
			Node node = Network.get(i);
			Vicinity vicinity = (Vicinity) node.getProtocol(pid_vicinity);
			vicinity.position = position;
		}
		
		// set up cyclon view
		for (int i = 0; i < size; i++)
		{
			Node node = Network.get(i);
			Cyclon cyclon = (Cyclon) node.getProtocol(pid_cyclon);		
			int view = cyclon.getViewLength();
			
			for (Integer value: getXRandomNumbers(view, i))
			{
				// recover the vicinity protocol of the node to add
				Node tmp_node = Network.get(value);
				Vicinity vicinity = (Vicinity) tmp_node.getProtocol(pid_vicinity);
				
				// add the neighbours to cyclon
				VicinityDescriptor pd = new VicinityDescriptor();
				pd.setNode(Network.get(value));			
				pd.setPosition(vicinity.position);
				
				cyclon.addNeighbour(pd);
			}		
		}
		
		return false;
	}
	
	/**
	 * Get a x number of node's IDs from the network, avoiding the
	 * "avoid" id.
	 * @param x
	 * @param avoid
	 * @return
	 */
	private Set<Integer> getXRandomNumbers(int x, int avoid)
	{
		Set<Integer> set = new HashSet<Integer>(x);
		
		while (set.size() < x) 
		{
			int candidate = avoid;
			while (candidate == avoid)
			{
				candidate = CommonState.r.nextInt(Network.size()) % (x * x);
			}
			set.add(candidate);
		}
		   
		return set;
	}
}
