package peersim;

import peersim.config.Configuration;
import peersim.core.CommonState;
import peersim.core.Control;
import peersim.core.Network;
import peersim.core.Node;
import peersim.util.IncrementalStats;

/**
 * This class implements the observer, that prints
 * a summary of the state of the network at every iteration.
 * @author carlini
 */

public class VicinityObserver implements Control
{
	/*
	 * Only one parameter: the protocol to reference.
	 * "PAR_PROTID" contains the parameter name to be used in the config file.
	 * "pid" will contains the value of the protocol referenced.
	 */
	private final String PAR_PROTID = "protocol";
	private final int pid;
	
	public VicinityObserver(String name)
	{
		pid = Configuration.getPid(name+"."+PAR_PROTID);
	}
	
	
	/**
	 * 
	 * 
	 */
	@Override
	public boolean execute() 
	{
		int time = CommonState.getIntTime();
		System.out.println("====== "+time);
		IncrementalStats stats = new IncrementalStats();
		
		for (int i=0; i < Network.size(); i++) 
		{
			Node node = Network.get(i);
			Vicinity prot = (Vicinity) node.getProtocol(pid);
			
			// let's compute the average of the distance of the view
			double total_dist = 0;
			for (VicinityDescriptor vd: prot.view.values())
			{
				double dist = vd.getPosition().distance(prot.position);
				total_dist += dist;
			}
			stats.add(total_dist/prot.view.size());
		}		
		
		System.out.println(stats.getAverage());
		
		return false;
	}

}
