package peersim;

import peersim.config.Configuration;
import peersim.core.CommonState;
import peersim.core.Control;
import peersim.core.Network;
import peersim.core.Node;

/**
 * This class initializes the values of the node in the network. 
 * @author carlini
 *
 */
public class AntiEntropyInitializer implements Control
{
	/*
	 * Only one parameter: the protocol to reference.
	 * "PAR_PROTID" contains the parameter name to be used in the config file.
	 * "pid" will contains the value of the protocol referenced.
	 */
	private final String PAR_PROTID = "protocol";
	private final int pid;
	
	public AntiEntropyInitializer(String name)
	{
		pid = Configuration.getPid(name+"."+PAR_PROTID);
	}
	
	/**
	 * This control works only at the first iteration.
	 * It assigns the state infective to a random node
	 */
	@Override
	public boolean execute() 
	{
		// this the random node 
		int random = CommonState.r.nextInt(Network.size());
		
		Node node = Network.get(random);
		AntiEntropy protocol = (AntiEntropy) node.getProtocol(pid);
		protocol.infective = true;
	
		return false;
	}
	
}
