package peersim;

import java.util.HashSet;
import java.util.Set;

import peersim.config.Configuration;
import peersim.core.CommonState;
import peersim.core.Control;
import peersim.core.Network;
import peersim.core.Node;

/**
 * This class initializes the neighborhood of the node in the network. 
 * @author carlini
 *
 */
public class CyclonInitializer implements Control
{
	/*
	 * Only one parameter: the protocol to reference.
	 * "PAR_PROTID" contains the parameter name to be used in the config file.
	 * "pid" will contains the value of the protocol referenced.
	 */
	private final String PAR_PROTID = "protocol";
	private final int pid;
	
	public CyclonInitializer(String name)
	{
		pid = Configuration.getPid(name+"."+PAR_PROTID);
	}
	
	/**
	 * This control works only at the first iteration.
	 * It initiliazes the view of the nodes.
	 */
	@Override
	public boolean execute() 
	{	
		// for each node...
		int size = Network.size();
		for (int i = 0; i < size; i++)
		{
			Node node = Network.get(i);
			Cyclon cyclon = (Cyclon) node.getProtocol(pid);
			int view = cyclon.getViewLength();
			
			for (Integer value: getXRandomNumbers(view, i))
			{
				PeerDescriptor pd = new PeerDescriptor();
				pd.setNode(Network.get(value));
				cyclon.addNeighbour(pd);
			}
		}
		
		return false;
	}
	
	/**
	 * Get a x number of node's IDs from the network, avoiding the
	 * "avoid" id.
	 * @param x
	 * @param avoid
	 * @return
	 */
	private Set<Integer> getXRandomNumbers(int x, int avoid)
	{
		Set<Integer> set = new HashSet<Integer>(x);
		
		while (set.size() < x) 
		{
			int candidate = avoid;
			while (candidate == avoid)
			{
				candidate = CommonState.r.nextInt(Network.size()) % (x * x);
			}
			set.add(candidate);
		}
		   
		return set;
	}
	
}
