package peersim;

import java.util.ArrayList;

import peersim.cdsim.CDProtocol;
import peersim.config.Configuration;
import peersim.core.CommonState;
import peersim.core.Linkable;
import peersim.core.Node;

public class AntiEntropy implements CDProtocol, Linkable
{
	// This array contains the neighbours of the node 
	// All the arrays of all the nodes define the topology of the network.
	// It is fixed during all the computation
	protected ArrayList<Node> neighbours;
	
	// At the start nodes are not infected
	protected boolean infective = false;
	
	
	/** config parameter the mode
	 * 0: push
	 * 1: pull
	 * 2: pushpull
	 */
	public static final String PAR_MODE = "mode";
	private int mode;
	
	
	public AntiEntropy(String prefix)
	{
		mode = Configuration.getInt(prefix+"."+PAR_MODE);
		init();
	}
			
	public boolean isInfective()
	{
		return infective;
	}

	public void init()
	{
		neighbours = new ArrayList<Node>();
	}
	
	@Override
	public void nextCycle(Node node, int pid) 
	{		
		Linkable linkable = (Linkable) node.getProtocol(pid);
		Node peer = linkable.getNeighbor(CommonState.r.nextInt(linkable.degree()));
		AntiEntropy neighbor = (AntiEntropy) peer.getProtocol(pid);
		
		if (linkable.degree() <= 0)
			return; // chosen node is disconnected
			
		
		switch (mode)
		{
			case 0: // push 
			{			
				if (this.infective)
					neighbor.infective = true;
				break;
			}
			case 1: // pull
			{
				
				if (neighbor.isInfective())
					this.infective = true;
				break;
			}
			case 2: // pushpull
			{
				boolean caller_infective = false;
				boolean receiver_infective = false;
				
				if (this.infective || neighbor.isInfective()) 
					receiver_infective = true;
				
				if (neighbor.isInfective() || this.infective)
					caller_infective = true;
				
				this.infective = caller_infective;
				neighbor.infective = receiver_infective;	
				
				break;			
			}
		}
	}
	


	/**
	 * This is the default mechanism of peersim to create 
	 * copies of objects. To generate a new protocol,
	 * peersim will call this clone method.
	 */
	public Object clone()
	{
		AntiEntropy p = null;
		try
		{ 
			p = (AntiEntropy) super.clone();
			p.init();
		}
		catch( CloneNotSupportedException e ) {} // never happens
		return p;
	}
	
	@Override
	public void onKill() {
		neighbours = null;
	}

	@Override
	public int degree()
	{
		return neighbours.size();
	}

	@Override
	public Node getNeighbor(int i) 
	{
		return neighbours.get(i);
	}

	/**
	 * Add a node only if the node is not already present
	 */
	@Override
	public boolean addNeighbor(Node neighbour) 
	{
		if (neighbours.contains(neighbour))
			return false;
		
		neighbours.add(neighbour);
		return true;
	}

	@Override
	public boolean contains(Node neighbor) 
	{
		return neighbours.contains(neighbor);
	}

	@Override
	public void pack() {
		System.out.println("Average.pack() -- not implemented");
	}
}
