package peersim;

import peersim.config.Configuration;
import peersim.core.Control;
import peersim.core.Network;
import peersim.core.Node;

public class AntiEntropyObserver implements Control
{
	/*
	 * Only one parameter: the protocol to reference.
	 * "PAR_PROTID" contains the parameter name to be used in the config file.
	 * "pid" will contains the value of the protocol referenced.
	 */
	private final String PAR_PROTID = "protocol";
	private final int pid;
	
	public AntiEntropyObserver(String name)
	{
		pid = Configuration.getPid(name+"."+PAR_PROTID);
	}
	
	
	/**
	 * Computes the network average, and the standard deviation.
	 * Terminates when the standard deviation goes below a threshold.
	 */
	@Override
	public boolean execute() 
	{
		double count = 0;
		
		for (int i=0; i < Network.size(); i++) 
		{
			Node node = Network.get(i);
			AntiEntropy protocol = (AntiEntropy) node.getProtocol(pid);
			if (protocol.isInfective()) 
				count++;
		}
		
		System.out.println("Infective: "+count+ " out of "+Network.size()+ " ("+count/Network.size()+")");
		
				
		if (count >= Network.size())
			return true;
		else
			return false;
	}

}
