package peersim;

import java.awt.geom.Point2D;

import peersim.core.Node;

public class VicinityDescriptor implements Comparable<VicinityDescriptor>
{
	private Node node;
	private long age = 0;
	protected Point2D.Double position;
	
	
	public Node getNode() 
	{
		return node;
	}
	
	public Long getNodeId()
	{
		return node.getID();
	}
	
	public void setNode(Node node)
	{
		this.node = node;
	}
	
	public long getAge()
	{
		return age;
	}
	
	public void increaseAge()
	{
		this.age ++;
	}
	
	public Point2D.Double getPosition() 
	{
		return position;
	}

	public void setPosition(Point2D.Double position) 
	{
		this.position = position;
	}


	@Override
	public int compareTo(VicinityDescriptor pd) 
	{
		if (pd.age < this.age)
			return -1;
		else if (pd.age > this.age)
			return 1;
		else return 0;
	}
	
	@Override
	public VicinityDescriptor clone()
	{
		VicinityDescriptor pd = new VicinityDescriptor();
		pd.node = this.node;
		pd.age = this.age;
		pd.position = this.position;
		return pd;
	}
	
	@Override
	public String toString()
	{
		return "("+node.getID()+")" + ";"+age+";"+this.position.getX()+","+this.position.getY();
	}
}
